 function graphe3D(M,xt,Ep,m,E,para)
% GRAPHE3D permet de tracer le facteur de transmission T en fonction de
% l'nergie et d'un paramtre au choix. 
%   GRAPHE3D(M,xt,Ep,m,E,para)
%       >> M = Nom des marches
%       >> xt = Position des marches
%       >> Ep = Valeurs des nergies potentielles
%       >> m = Masse de l'objet physique
%       >> E = Valeurs des nergies de l'objet physique
%       >> para = Valeurs du paramtre caractristique de l'nergie
%       potentielle
%       << Figure
%
% Olivier Pujol : septembre 2013
%

iconf=input('Etats confins : non (tapez 0) / oui (tapez 1) ?');
im=input('Quel est le numro (indice) de la marche concerne ? ');
type=input('Type de paramtre pour la marche choisie : paisseur (tapez 1) / hauteur (tapez 2) :');

% On demande s'il faut dcaler les marches qui suivent la marche considre (im)
if type==1 && size(xt,2)>2
    decale=input('Dcalage en consquence des marches qui suivent : non (tapez 0) / oui (tapez 1) :');
end
if (size(xt,2)<3),decale=0;end     % Cas d'une seule barrire/d'un seul puits

% Vrification
if (im > length(xt)) || (im < 1) 
    disp(' ');
    disp(['La marche numro', num2str(im),'n''existe pas !']);
    disp(['Il faut 1 <= im <= ', num2str(length(xt)),' ! ']);
    disp(' ');
    return;
end

% Pour chaque valeur du paramtre, il faut calculer le systme, puis la
% matrice de transfert et enfin les facteurs R et T. 

R=nan(length(E),length(para));      % Initialisation
if (iconf==0)
    T=nan(length(E),length(para));  % Initialisation de T (tats de diffusion)
else
    d=nan(length(E),length(para));  % Initialisation (tats confins)
end

switch type
    case 1    % Le paramtre en question est la position de l'une des marches
        
        if (para(1)<=xt(im-1))
            error('La valeur minimale du paramtre est infrieure ou gale  la position de la marche prcdente !');
        end

        xt=repmat(xt,length(para),1);   % On rplique le vecteur ligne xt autant de fois qu'il y a de valeurs du paramtre 

        switch decale
            case 0      % On ne dcale pas les matrices suivantes
                if (para(end)>=xt(im+1) && size(xt,2)>=3)
                    error('La valeur maximale du paramtre est suprieur ou gal  la position de la marche suivante !');
                end
                xt(:,im)=para'; % Nouvelle matrice xt
                
            case 1      % On dcale en consquence les matrices suivantes
                delta=para'-xt(1,im);
                for i=im:size(xt,2)
                    xt(:,i)=xt(:,i)+delta;  % Nouvelle matrice xt
                end                
        end
                
        for ipara=1:length(para)
            [sys]=Epot(M,xt(ipara,:),Ep,m,E);
            TES=matrix(sys);
            switch iconf
                case 0
                [R(1:length(sys),ipara),T(1:length(sys),ipara)]=factRT(sys,TES);
                case 1
                d(1:length(sys),ipara)=Calc_d(TES);
            end
        end
        
    case 2    % Le paramtre en question est la hauteur de l'une des marches 
              % (Attention : marche d'indice 1 --> Hauteur d'indice 2
        
        Ep=repmat(Ep,length(para),1);
        Ep(:,im+1)=para';
        
        for ipara=1:length(para)
            [sys,E]=Epot(M,xt,Ep(ipara,:),m,E);
            TES=matrix(sys);
            switch iconf
                case 0
                [R(1:length(sys),ipara),T(1:length(sys),ipara)]=factRT(sys,TES);
                case 1
                d(1:length(sys),ipara)=Calc_d(TES);
            end
        end       
end

clear TES sys

% Figure
figure
if (iconf==0),surf(para,E,T);end              % Le choix de reprsentation est libre (surf, mesh, etc.). Cf. Matlab help
if (iconf==1),surf(para,E,log(abs(d)));end      % Idem
shading interp;
colormap('jet');
colorbar('vertical');
if (type==1);xlabel(['Position de la marche ',num2str(im),' (nm) ']);end
if (type==2);xlabel(['Hauteur de la marche ',num2str(im),' (eV) ']);end
ylabel('Energie  (eV)');
if (iconf==0),title('Facteur de transmission');end
if (iconf==1),title('Logarithme de la valeur absolue de d (lment de la matrice abcd)');end
axis tight

return;

function d=Calc_d(TES)

d=nan(1,length(TES));   % Initialisation

for i=1:size(TES,2)
    d(i)=TES{i}(2,2);   % Elment d
end

return;
